#include <bits/stdc++.h>
using namespace std;
struct Tacka
{
    int x, y;

    bool operator<(const Tacka& ostalo) const
    {
        return (x < ostalo.x) || (x == ostalo.x && y < ostalo.y);
    }
};

double PovrsinaOblika(const vector<Tacka>& tacke)
{
    double povrsina = 0.0;
    int n = tacke.size();
    for (int i = 0; i < n; i++)
    {
        povrsina += tacke[i].x * tacke[(i + 1) % n].y;
        povrsina -= tacke[(i + 1) % n].x * tacke[i].y;
    }
    return abs(povrsina)/2.0;
}


int desinger(const Tacka& o, const Tacka& a, const Tacka& b)
{
    return (a.x - o.x) * (b.y - o.y) - (a.y - o.y) * (b.x - o.x);
}

vector<Tacka> konveksno(vector<Tacka>& tacke) {
    sort(tacke.begin(), tacke.end());

    vector<Tacka> nize, vise;

    for (const auto& t : tacke)
    {
        while (nize.size() >= 2 && desinger(nize[nize.size() - 2], nize.back(), t) <= 0)
        {
            nize.pop_back();
        }
        nize.push_back(t);
    }

    for (int i = tacke.size() - 1; i >= 0; i--)
    {
        const auto& t = tacke[i];
        while (vise.size() >= 2 && desinger(vise[vise.size() - 2], vise.back(), t) <= 0)
        {
            vise.pop_back();
        }
        vise.push_back(t);
    }

    vise.pop_back();
    nize.pop_back();

    nize.insert(nize.end(), vise.begin(), vise.end());
    return nize;
}

int main() {
    int n; cin >> n;
    vector<Tacka> tacke(n);
    for (int i = 0; i < n; i++)
    {
        cin >> tacke[i].x >> tacke[i].y;
    }

    double minPov = 1e9;

    for (int i = 0; i < n; i++)
    {
        vector<Tacka> ostaleTacke;
        for (int j = 0; j < n; j++)
        {
            if (j != i)
            {
                ostaleTacke.push_back(tacke[j]);
            }
        }

        vector<Tacka> ica = konveksno(ostaleTacke);
        double povrsina = PovrsinaOblika(ica);
        minPov = min(minPov, povrsina);
    }
    cout << static_cast<int>(minPov) << endl;
    return 0;
}